tinycc/client
=============

This is official client for URL shortening service Tiny.cc (REST API v3.1).
Tiny.cc API has 'batch_operations_limit' which limits number of URLs you can affect in group operations.
However, sometimes you need to overcome this limitation. This client provides transparant 
handling of 'batch_operations_limit' using curl_multi_* functionality.

Detailed API documentation:
https://tinycc.com/tiny/api-docs

Quick Start
===========

Client instantiation:

	$client = new \tinycc\client(array(
		'api_root_url'=>"https://tinycc.com/tiny/api/3/",
		'username'=>'johndow',
		'api_key'=>'c3e49rce-ee35-44d9-a1bf-03522bd3b975',
	));

Simple shortening:

	$url = $client->shorten("https://google.com");
	print_r($url);
	
Mass shortening:
	$urls = mass_shorten(array("https://google.com","https://yahoo.com"), array("tags"=>array("foo")));
	print_r($url);

Delete URL:

	$client->select_with_hashes(array("hrke"))->delete();

Create tag:

	$client->create_tag('foo');

Tag URL:

	$client->select_with_hashes(array("hrke"))->edit(array("tags"=>array("+foo")));

Untag URL:

	$client->select_with_hashes(array("hrke"))->edit(array("tags"=>array("-foo")));

Reset click stats of tagged URL:

	$client->select_with_tags("foo")->reset_stats();

Read first tagged URL:

	$client->select_with_tags('foo')->read(array('limit'=>1));
	
Since APIv3.1, all operation (by default) performed on "default" domain.
To select different domain, use this code:

	$client->set_working_domain("my-domain.com");
	
Operations with tags, work across domains.
	

Methods summary
===============

Following methods, do not require preliminary selection of URLs:

void set_working_domain(string $domain) - switch current domain context
array account_info() - different information regarding user's account. Including API usage.
array shorten($long_url, array $data=array()) - shorten single URL (with optional custom properties)
array mass_shorten(array $long_urls, array $data=array()) - shorten many URLs (with optional custom properties)
array read_page(array $params = array()) - read paginated index of shortened URLs
array tags() - read list of available tags
array domains() - read list of available domains
array create_tag(string $label) - create new tag
array delete_tag(string $label) - delete tag (tagged URLs won't be deleted)

Selection methods (chainable):

client select_with_hashes(array $hashes)
client select_with_tags(string $tags_query)

Following methods require preliminary selection of URLs:

array read(array $params = array()) - read properties of selected URL(s). Expect the same parameters as read_page().
array edit(array $data) - change properties of selected URL(s). Will return updated URL(s) data when selecting with hashes.
void delete() - delete selected URL(s)
void reset_stats() - reset clicks stats for selected URL(s)
