﻿using Tinycc.Resources;

namespace Tinycc.ConsoleApplication;

internal class Program
{
    static void Main(string[] args)
    {
        RunAsync().Wait();
    }

    /// <summary>
    /// Sample calls for Tinycc API client
    /// </summary>
    static async Task RunAsync()
    {
        Client c = new Client("johndow", "c3e49rce-ee35-44d9-a1bf-03522bd3b975")
        {
            Domain = "my-domain.com"
        };

        var accountInfo = await c.AccountInfoAsync();

        var domains = await c.DomainsAsync();

        var tags = await c.TagsAsync();

        var createTag = await c.CreateTagAsync("tag4");

        var editTag = await c.EditTagAsync("tag4", "tag5");

        await c.DeleteTagAsync("tag2");

        var shorten = await c.ShortenAsync(new ShortenParams { LongUrl = "https://google.com" });

        var massShorten = await c.MassShortenAsync([
            new ShortenParams { LongUrl = "https://www.google.com" },
            new ShortenParams { LongUrl = "https://yahoo.com", ExpirationDate = DateTime.Now.AddDays(1), Tags = ["tag2"] },
            ], disableLongUrlDuplicates: "account");

        var read = await c.ReadAsync();

        var massRead = await c.ReadAsync(hashes: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "a"]);

        var readPage = await c.ReadPageAsync(offset: 3, limit: 5, orderBy: ReadOrderBy.Modified);

        var edit = await c.EditAsync(new EditParams
        {
            Hash = "4",
            CustomHash = "004"
        });

        var massEdit = await c.EditAsync([
            new EditParams { Hash = "1", Note = "Note 1" },
            new EditParams { Hash = "2", Note = "Note 2" },
        ]);

        var massEditByHashes = await c.EditAsync(
            new EditParams { Note = "Note 123" },
            hashes: ["1", "2", "3", "4", "5", "6", "7", "8", "9", "a"]);

        var editByHashes = await c.EditAsync(new EditParams { Note = "Common note" }, hashes: ["1", "2"]);

        await c.DeleteAsync("1");

        await c.DeleteAsync(hashes: ["71", "72", "73", "74", "75"]);

        var stats = await c.StatsAsync("4");

        await c.ResetStatsAsync("1");

        await c.ResetStatsAsync(hashes: ["1", "2", "3", "4", "5"]);

        var metaCriterion = await c.MetaCriterionAsync();

        var metaBrowser = await c.MetaBrowserAsync();

        var metaCountry = await c.MetaCountryAsync();

        var metaLanguage = await c.MetaLanguageAsync();

        var metaPlatform = await c.MetaPlatformAsync();

        var smartLink = await c.SmartLinkAsync("4");

        var editSmartLink = await c.EditSmartLinkAsync("4", [
            new Rule() { Arg = ["en"], Criterion= SmartLinkCriterion.Language, Url = "https://yahoo.com", Children = [
                new Rule() { Arg = ["ch"], Criterion= SmartLinkCriterion.Browser, Url = "https://yahoo.de" }
            ]}
        ]);
    }
}
